// eslint-disable-next-line no-unused-vars
/* global chrome, jQuery, $, qtip  */

if(typeof browser === 'undefined' && typeof chrome !== 'undefined') {
    var browser = chrome;
}

const harasslessAttrName = 'data-harassless-checked';
const detoxGuidAttrName = 'data-harassless-guid';
const querySelectors = `div:not([${harasslessAttrName}]), span:not([${harasslessAttrName}])`;
const textMinLength = 15;
const imgPrefix = 'img-';
const imgWrapperPrefix = 'img-wrapper-';
const jobsQueue = [];
const maxWork = 20;
const textCache = new Set();
const DETOX_MODES = { DISABLED: 0, STANDARD: 1, CHILDREN: 2, DEBUG: 3 }

const isHidden = (el) => {
    try {
        return (el.offsetParent === null)
    } catch {
        return true;
    }   
}

const enQueue = (job) => {
    jobsQueue.push(job);
}

const deQueue = (job) => {
    return jobsQueue.shift(job);
}

const isQueueEmpty = () => {
    return jobsQueue.length == 0;
}

const queueLength = () => {
    return jobsQueue.length;
}

const doJob = (job) => {
    browser.runtime.sendMessage(job);
}

const wrapDOMElement = (el, wrapper) => {
    el.parentNode.insertBefore(wrapper, el);
    wrapper.appendChild(el);
}

const createWrappedImg = (targetElement, id, color, url) => {

    let wrapper = document.createElement('div');
    wrapper.setAttribute('id', `${imgWrapperPrefix}${id}`);
    wrapper.style.margin = '5px';
    //wrapper.style.border = '1px dashed '+color+'';
    wrapper.style.position = 'relative';
    wrapper.style.cursor = 'pointer';

    const imgUrl = browser.extension.getURL(url);

    let img = document.createElement('img');
    img.src = imgUrl;
    img.setAttribute('id', `${imgPrefix}${id}`);
    img.style.position = 'absolute';
    img.style.backgroundColor = 'white';
    img.style.top = 0;
    img.style.right = 0;
    img.style.margin = '2px';
    img.style.height = '24px';
    img.style.width = '24px';
    img.style.display = 'none';
    wrapper.appendChild(img);
    wrapDOMElement(targetElement, wrapper);
}

const updateWrappedImg = (id, color, url) => {

    try {
    
        const wrapper = document.getElementById(`${imgWrapperPrefix}${id}`);
        wrapper.style.border = '1px dashed '+color+'';

        if(typeof wrapper === 'undefined' || wrapper == null)
            return;

        const img = document.getElementById(`${imgPrefix}${id}`);
        if(typeof img === 'undefined' || img == null)
            return;            

        img.src =  browser.extension.getURL(url);

        img.style.display = 'inline';
       
    } catch (e) {
        console.log(e);
    }
}

const hideWrappedContent = (id) => {

    try {

        const wrapper = document.getElementById(`${imgWrapperPrefix}${id}`);

        wrapper.style.border = 'none';

        if(typeof wrapper === 'undefined' || wrapper == null)
            return;

        const img = document.getElementById(`${imgPrefix}${id}`);

        if(typeof img === 'undefined' || img == null)
            return;            
       
        img.style.display = 'none';
        
    } catch (e) {
        console.log(e);
    }
}

const supressWrappedContent = (id, color, url) => {

    try {

        const wrapper = document.getElementById(`${imgWrapperPrefix}${id}`);
        //wrapper.style.border = '1px dashed '+color+'';
        wrapper.style.border = 'none';

        wrapper.innerText = '';
        //TODO: discuss the best option: remove the content of the element Vs remove the element itself.
        //wrapper.style.display = 'none';
     
        if(typeof wrapper === 'undefined' || wrapper == null)
            return;

        const img = document.getElementById(`${imgPrefix}${id}`);

        if(typeof img === 'undefined' || img == null)
            return;            

        img.src =  browser.extension.getURL(url);
            
    } catch (e) {
        console.log(e);
    }
}

const generateGuid = () => {
    return Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
}

// eslint-disable-next-line no-unused-vars
const chunkSubstr = (str, size) => {

    const numChunks = Math.ceil(str.length / size)
    const chunks = new Array(numChunks)
  
    for (let i = 0, o = 0; i < numChunks; ++i, o += size) {
        chunks[i] = str.substr(o, size)
    }
  
    return chunks
}

const checkForChildren = (el, querySelector) => {

    let foundInNode = 0;
   
    try {
        if($(el).children().length == 0) {
            return foundInNode;
        }
        
        let matched = $(el).children(querySelector);
    
        if(matched.length > 0) {
            return matched;
        } else {
  
            let children = el.children;
            for (let i = 0; i < children.length; i++) {
                let childElement = children[i];
                if(isHidden(childElement) == false)
                    foundInNode += checkForChildren(childElement, querySelector);
                if(foundInNode > 0) {
                    break;
                }
            }            
        }
    // eslint-disable-next-line no-empty
    } catch (error) {
        console.error(error);
    }
        
    return foundInNode;
}

const detoxSearch = (attentionTarget) => {
          
    document.querySelectorAll(attentionTarget).forEach((el) => {

        try {
             
            const textContent = el.innerText ? el.innerText : '';

            console.debug(`### detox to detect: ${textContent} ###`);
                 
            if(
                /**
                 *  "checkForChildren" and children check rukles need to be better tested,
                    as there might be also related with some content missed in Twitter.                                      
                */                                                              
                checkForChildren(el, 'DIV') == 0 && checkForChildren(el, 'SPAN') == 0
                && $(el).children('['+detoxGuidAttrName+']').length == 0 
                && isHidden(el) === false 
                && typeof($(el).attr('['+detoxGuidAttrName+']')) == 'undefined'
                && textCache.has(textContent) == false 
                && textContent.length > textMinLength) {
                    
                textCache.add(textContent);               
                const detoxGuid = generateGuid();
    
                el.style.opacity = '0';
                el.setAttribute(harasslessAttrName, '0');
                el.setAttribute(detoxGuidAttrName, detoxGuid);
                createWrappedImg(el, detoxGuid, 'orange', 'images/icon32.png');
            
                const textJob = {action:'textClickCheck', text: textContent, localUrl: window.location.href, detoxGuid};
    
                if(queueLength() <= maxWork)
                    doJob(textJob)                    
                else
                    enQueue(textJob);                
            } 
                
        } catch (error) {
            console.log(error);
        }
    
    });

}

const observeDOM = (function(){
    let MutationObserver = window.MutationObserver || window.WebKitMutationObserver,
        eventListenerSupported = window.addEventListener;
    return function(obj, callback){
        if( MutationObserver ){
            // eslint-disable-next-line no-unused-vars
            let obs = new MutationObserver(function(mutations, _observer){
               
                if(mutations[0].addedNodes.length) {

                    try {                                        
                        callback();                                                 
                    } catch (error) {
                        console.log(`mutation error: ${error.message}`);
                    }
                  
                }

            });
            obs.observe( obj, { childList:true, subtree:true, attributes: true,
                characterData: true});
        }
        else if( eventListenerSupported ) {
            //obj.addEventListener('DOMNodeInserted', callback, false);
        }
    };
})();

(() => {

    console.log('detox client ready!');

    browser.runtime.onMessage.addListener(function(backMessage) {
       
        try {
            
            if(typeof backMessage !== undefined && typeof backMessage.detoxGuid !== undefined){

                const guid = backMessage.detoxGuid;
                const query = `[${detoxGuidAttrName}="${guid}"]`;
              
                if($(query).length > 0)
                {                                           
                    if(backMessage.toxicCategories && backMessage.toxicCategories.length > 0) {
                                                            
                        if(backMessage.detoxCheckMode && backMessage.detoxCheckMode != DETOX_MODES.CHILDREN)
                        {        
                            const wireframeColour = backMessage.detoxCheckMode == DETOX_MODES.DEBUG ? 'red' : 'transparent';
                            updateWrappedImg(guid, wireframeColour, 'images/icon32-red-2.png');
                   
                            $(query).css('opacity', '1');

                            $(`#${imgPrefix}${guid}`).qtip({
                                style: {
                                    classes: 'nrg-tooltip-red'
                                },
                                overwrite: true,
                                content: {
                                    text: backMessage.htmlContent
                                },
                                show: {
                                    solo: true,
                                    event: 'mouseenter',
                                    ready: true                
                                },
                                hide: {
                                    event: 'mouseleave'
                                },
                                position: {
                                    my : 'bottom center',
                                    at: 'top right',
                                    adjust: {
                                        method: 'Shift'
                                    }
                                }            
                            });
                        }
                        else {                         
                            supressWrappedContent(guid, 'red', 'images/icon32-red-2.png');
                        }                            

                    } else {
               
                        if(backMessage.detoxCheckMode == DETOX_MODES.DEBUG 
                        && backMessage.okCategories && backMessage.okCategories.length > 0)                                                    
                            updateWrappedImg(guid, 'green', 'images/icon32-green.png');                        
                        else                           
                            hideWrappedContent(guid);
                                                                                                        
                        $(query).css('opacity', '1');                                                                
                    }    
                                        
                }
            }
          
        } catch (e) {
            console.log(`detox family error: ${e}`);
        }
        finally {

            if(!isQueueEmpty())
                doJob(deQueue());
        }
        

    });

    const detectionTargets = [];    
    const attentionHost = location.hostname.replace('www.',''); 
    // eslint-disable-next-line no-undef
    const attentionTarget = attentionDomains.get(attentionHost);

    if(attentionTarget) {                   
        detectionTargets.push(`${attentionTarget}:not([${harasslessAttrName}])`);  
    } else {
        detectionTargets.push(querySelectors);       
    }

    detoxSearch.apply(this, detectionTargets);

    observeDOM(window.document, ()=>{
        console.log(`mutation callback called.`);     
        detoxSearch.apply(this, detectionTargets);
    });

})();